﻿/* 
 * .NET Assembly Data Source example for Exago BI
 * This is a trivial example that builds a data set in memory and outputs it for reporting.
 * See https://support.exagoinc.com/hc/en-us/articles/360003346154 for setup information.
 */

namespace SampleADS
{
    using System;
    using System.Data;
    /*using WebReports.Api.Common;*/ // If using SessionInfo, include a reference to WebReportsApi.dll

    public class Tables
    {
        public Tables()
        {
            // Any preparatory procedures can be within a public constructor
        }

        // Parameter names must be set in Programmable Object Settings
        public static DataSet EntryPoint(/*SessionInfo sessionInfo, */int CallType, string Columns, string Filter,
            string FullFilter, string Sort, string Category, string Id, object RowLimit, object RowStart, object RowEnd)
        {
            if (CallType == 0) // Schema: Exago BI has requested the schema (column names) of the table
            {
                return GetSchema();
            }

            DataSet FullDataSet = BuildData();
            DataRow[] FilteredRows = null;

            if (CallType == 1) // Data: Exago BI has requested the data set
            {
                // Can simply return the full data set and let Exago BI do the filtering
                // Or use Columns and Filter params to do the filtering in code (possible with Exago v2018.1 or later)
                FilteredRows = FullDataSet.Tables[0].Select(Filter, Sort);
                // Note: This is a primitive usage of DataTable.Select()
                // For info on how to use this method robustly, see http://www.csharp-examples.net/dataview-rowfilter/
            }

            if (CallType == 2) // Filter: Exago BI has requested filter dropdown values for a data column
            {
                // Use Columns, Filter, and FullFilter params to return only the requested column values
                // This is necessary because Exago BI will not filter the filter dropdowns by default
                if (!string.IsNullOrEmpty(FullFilter))
                    FullFilter += " AND ";
                string FilterExpression = FullFilter + $"(CONVERT({Columns}, System.String) LIKE '%{Filter}%')";
                FilteredRows = FullDataSet.Tables[0].Select(FilterExpression);
            }

            if (FilteredRows.Length > 0)
            {
                DataSet FilteredSet = new DataSet();
                FilteredSet.Merge(FilteredRows);
                return FilteredSet;
            }

            return GetSchema();
        }

        static DataSet GetSchema()
        {
            DataSet set = new DataSet();
            DataTable table = new DataTable();
            table.Columns.Add(new DataColumn("id", typeof(int)));
            table.Columns.Add(new DataColumn("name", typeof(string)));
            table.Columns.Add(new DataColumn("dob", typeof(DateTime)));
            set.Merge(table);
            return set;
        }

        static DataSet BuildData()
        {
            // Could implement this in a more performant manner to only build the requested columns.
            // This would be more important for larger, external data sets.
            DataSet set = GetSchema();

            foreach (object[] record in new object[][]
            {
                new object[] { 0, "Alex", new DateTime(1991, 02, 24) },
                new object[] { 1, "Dave", new DateTime(1989, 04, 15) },
                new object[] { 2, "Nick", new DateTime(1970, 12, 13) },
                new object[] { 3, "Emma", new DateTime(1994, 09, 26) },
                new object[] { 4, "Mark", new DateTime(1990, 03, 05) },
            })
            {
                DataRow row = set.Tables[0].NewRow();
                row[0] = record[0];
                row[1] = record[1];
                row[2] = record[2];
                set.Tables[0].Rows.Add(row);
            }

            return set;
        }
    }
}
